`timescale 1ps / 1ps
//module 'serial_io' generates patterns for SPI signals, reads serial LTC2374 data and converts it to parallel using Altera MAXII
//GMH
//March 22, 2013  RevA
module serial_io(master_clk, mosi, miso, data_latch, sck, conv, aux0, dout, mcd, B16_18L, WRIN, delay);	 
   input master_clk;	   								// external clock in
   input mcd;    											// mcd is a delayed version of master_clk
	input B16_18L;											// 1=16bits, 0=18bits
	input WRIN;												// resets serial_io when WRIN goes low
   output mosi;			  								// sdi to adc (some parts may not use this line)
   input miso;												// sdo to cpld (serial data from ADC)
   output data_latch;									// latches data into cpld   (active high)
   output sck;												// gated version of external clock in with some delay
   output conv;											// convert or CS to ADC
   output aux0;  											// aux output   
   output [25:0] dout;									// 18-bit deserialized data from ADC plus 7-bit config string	
	output [7:0] delay;
   reg [31:0] aux0_shift;
   reg [31:0] conv_shift;
   reg [31:0] data_latch_shift;
   reg [31:0] delay_shift;												
   reg [31:0] mosi_shift;
   reg [31:0] sck_shift;
   reg [25:0] dout;	  					
   reg [7:0] delay;
   reg [6:0] clk_counter;
   wire[7:0] delay_time;
   wire[6:0] max_clk_cnt;
  // wire[4:0] num_bits;
  // wire[3:0] num_channels;
   wire aux0;		 
   wire data_latch;
   wire master_clk;
   wire mcd;
	wire B16_18L;
	wire WRIN;
   wire miso;
   wire mosi;
   wire sck;
	reg [31:0]miso_def;
	reg [31:0]mosi_def;
	reg [31:0]data_latch_def;
	reg [31:0]sck_def;
	reg [31:0]conv_def;
	reg [31:0]aux0_def;
	reg [31:0]delay_def;
	
	
	always @( B16_18L )begin
	if (B16_18L==0) begin
																	//  up to 4 16bit channels in 64bits. Increase to 144 to do 8 channels of 18bits
																	//  counts per delay	 		max clk count 		# of channels 	# of bits 
																	//   b16-b23(max 255)	   b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																	//		33									30			         1		  		   18	   
          miso_def <= 32'H00203A31;    				//  0010 0000						0011 	101			0 001 		 	1 0001   	                               												      
          mosi_def <= 32'H00000000;    				//  0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 32'H20000000;    				//  0010 0000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 32'H1FFFFFF8;    				//  0001 1111 1111 1111 1111 1111 1111 1000    	    	                               
          conv_def <= 32'HFFFFFFFC;    				//  1111 1111 1111 1111 1111 1111 1111 1100 	   	    	          	                           
          aux0_def <= 32'H00000001;						//  0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 32'H00000002;      				//  0000 0000 0000 0000 0000 0000 0000 0010 

	end	    
				else begin   

																	//  up to 4 16bit channels in 64bits. Increase to 144 to do 8 channels of 18bits
																	//  counts per delay	 		max clk count 		# of channels 	# of bits 
																	//   b16-b23(max 255)	   b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																	//		29									28			         1		  		   16	   
          miso_def <= 32'H001C362F;    				//  0001 1100						0011 	011			0 001 		 	0 1111   	         //11/17/14 counts per delay changed to 29 to meet max tconv spec                      												      
          mosi_def <= 32'H00000000;    				//  0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 32'H08000000;    				//  0000 1000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 32'H07FFFFF8;    				//  0000 0111 1111 1111 1111 1111 1111 1000    	    	                               
          conv_def <= 32'HFFFFFFFC;    				//  1111 1111 1111 1111 1111 1111 1111 1100 	   	    	          	                           
          aux0_def <= 32'H00000001;						//  0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 32'H00000002;      				//  0000 0000 0000 0000 0000 0000 0000 0010 

				end
    end
	
	assign max_clk_cnt =  miso_def[15:9];				// maximum count before clk_counter is reset	(max 127)   
	//assign num_bits =  miso_def[4:0];					// number of bits	(max 32)  
	//assign num_channels =   miso_def[8:5];			// number of channels (max 16)	  
	assign delay_time =  miso_def[23:16];				// number of master_clks to wait if delay goes high (max 255)
	assign data_latch = data_latch_shift[0] ;										   						
	assign mosi = mosi_shift[0];						
	assign aux0 = aux0_shift[0];
	assign sck = (sck_shift[0]& mcd);					//was master_clk		mcd gives proper delay
	wire conv;
	assign	conv = !(conv_shift[0]);												
   initial begin //
   delay <= 0;															
   clk_counter <= 7'b0000000;								// initialize counter loop   
   aux0_shift<= 32'H00000000;
   conv_shift<= 32'H00000000;
   data_latch_shift<= 32'H00000000;
   delay_shift<= 32'H00000000;
   mosi_shift<= 32'H00000000;
   sck_shift<= 32'H00000000;
   dout<= 26'b00000000000000000000000000;		    							      
   end //
 
always @(negedge master_clk or negedge WRIN)		begin						// everything happens on neg edge of master clk
if (WRIN==0) begin//											//if WRIN goes low reset clk_counter
	clk_counter<= max_clk_cnt;								//was 7'b0000000
	data_latch_shift <= data_latch_def;				//	
	conv_shift <= conv_def;									//
	mosi_shift <= mosi_def;										// added 1/13/14 to force reset when WRIN low 
	sck_shift <= sck_def;											//
	aux0_shift <= aux0_def;										//
	delay_shift <= delay_def;								//
   delay <= 0;												//	
end//

else begin//
if (delay_shift[0]==1)begin///	 										
	if (delay<delay_time)begin	////									
		delay <= delay + 8'b00000001; 											
	end	////	
	
	else begin////													
		if(delay == delay_time) begin/////							
			clk_counter <= clk_counter- 7'b0000001;							
			data_latch_shift <= data_latch_shift >> 1;				
		   	conv_shift <= conv_shift >> 1 ;							
			mosi_shift <= mosi_shift >> 1;							
			sck_shift <= sck_shift >> 1;							
			aux0_shift <= aux0_shift >> 1;							
			delay_shift <= delay_shift >> 1;						
		    delay <= 0;												
		end /////													
	end ////															
end///																
else begin///														
	if (clk_counter > 0) begin ////		  							
		clk_counter <= clk_counter - 7'b0000001;		  						
		data_latch_shift <= data_latch_shift >> 1;
		conv_shift <= conv_shift >> 1 ;
		mosi_shift <= mosi_shift >> 1;
		sck_shift <= sck_shift >> 1;
		aux0_shift <= aux0_shift >> 1;
		delay_shift <= delay_shift >>1;													
	 end ////	
	 else begin ////
		    clk_counter <= max_clk_cnt;			  		//if clk_counter=0 reset clk_counter 
			data_latch_shift <= data_latch_def;						
			conv_shift <= conv_def;
			mosi_shift <= mosi_def;
			sck_shift <= sck_def;
			aux0_shift <= aux0_def;
			delay_shift <= delay_def;												 			  
	end ////
end///
end//
end
always @(posedge sck) begin 							// sck is inverted from master clk
	dout <= {dout[24:0],miso};								// latch data bit, place in proper location of dout
end 

endmodule